/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterfortresses.world;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterfortresses.BetterFortressesCommon;
import com.yungnickyoung.minecraft.betterfortresses.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.betterfortresses.world.ItemFrameChances;
import com.yungnickyoung.minecraft.yungsapi.world.processor.StructureEntityProcessor;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ItemFrameProcessor
extends StructureEntityProcessor {
    public static final ItemFrameProcessor INSTANCE = new ItemFrameProcessor();
    public static final Codec<class_3491> CODEC = Codec.unit(() -> INSTANCE);

    public class_3499.class_3502 processEntity(class_5425 serverLevelAccessor, class_2338 structurePiecePos, class_2338 structurePieceBottomCenterPos, class_3499.class_3502 localEntityInfo, class_3499.class_3502 globalEntityInfo, class_3492 structurePlaceSettings) {
        if (globalEntityInfo.field_15598.method_10558("id").equals("minecraft:item_frame")) {
            String item;
            class_5819 random = structurePlaceSettings.method_15115(globalEntityInfo.field_15600);
            try {
                item = globalEntityInfo.field_15598.method_10562("Item").method_10580("id").toString();
            }
            catch (Exception e) {
                BetterFortressesCommon.LOGGER.info("Unable to randomize item frame at {}", (Object)globalEntityInfo.field_15600);
                return globalEntityInfo;
            }
            class_2487 newNBT = globalEntityInfo.field_15598.method_10553();
            switch (item) {
                case "\"minecraft:stone_sword\"": {
                    String randomItemString = class_7923.field_41178.method_10221((Object)ItemFrameChances.get().getWeaponItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    newNBT.method_10562("Item").method_10582("id", randomItemString);
                    break;
                }
                case "\"minecraft:iron_ingot\"": {
                    String randomItemString = class_7923.field_41178.method_10221((Object)ItemFrameChances.get().getLootItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    newNBT.method_10562("Item").method_10582("id", randomItemString);
                    break;
                }
                case "\"minecraft:cobweb\"": {
                    String randomItemString = class_7923.field_41178.method_10221((Object)ItemFrameChances.get().getStudyItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    if (randomItemString.equals("minecraft:enchanted_book")) {
                        float f = random.method_43057();
                        String enchantment = f < 0.2f ? "minecraft:fire_aspect" : (f < 0.4f ? "minecraft:fire_protection" : (f < 0.6f ? "minecraft:flame" : (f < 0.8f ? "minecraft:smite" : "minecraft:binding_curse")));
                        int lvl = enchantment.equals("minecraft:flame") || enchantment.equals("minecraft:binding_curse") ? 1 : (random.method_43057() < 0.75f ? 1 : 2);
                        class_2487 tag = new class_2487();
                        class_2499 storedEnchantments = (class_2499)class_156.method_654((Object)new class_2499(), listTag -> listTag.add((Object)((class_2520)class_156.method_654((Object)new class_2487(), compoundTag -> {
                            compoundTag.method_10575("lvl", (short)lvl);
                            compoundTag.method_10582("id", enchantment);
                        }))));
                        tag.method_10566("StoredEnchantments", (class_2520)storedEnchantments);
                        newNBT.method_10562("Item").method_10566("tag", (class_2520)tag);
                    }
                    newNBT.method_10562("Item").method_10582("id", randomItemString);
                    break;
                }
                case "\"minecraft:apple\"": {
                    String randomItemString = class_7923.field_41178.method_10221((Object)ItemFrameChances.get().getMessHallItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    newNBT.method_10562("Item").method_10582("id", randomItemString);
                    break;
                }
                case "\"minecraft:nether_wart\"": {
                    String randomItemString = class_7923.field_41178.method_10221((Object)ItemFrameChances.get().getAlchemyItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    newNBT.method_10562("Item").method_10582("id", randomItemString);
                    break;
                }
                case "\"minecraft:glowstone_dust\"": {
                    if (random.method_43056()) {
                        newNBT.method_10562("Item").method_10582("id", "minecraft:blaze_powder");
                        break;
                    }
                    return null;
                }
            }
            newNBT.method_10569("TileX", globalEntityInfo.field_15600.method_10263());
            newNBT.method_10569("TileY", globalEntityInfo.field_15600.method_10264());
            newNBT.method_10569("TileZ", globalEntityInfo.field_15600.method_10260());
            int minRotation = item.equals("\"minecraft:chiseled_nether_bricks\"") ? 1 : 0;
            int randomRotation = class_3532.method_32751((class_5819)random, (int)minRotation, (int)7);
            newNBT.method_10567("ItemRotation", (byte)randomRotation);
            globalEntityInfo = new class_3499.class_3502(globalEntityInfo.field_15599, globalEntityInfo.field_15600, newNBT);
        }
        return globalEntityInfo;
    }

    @Nullable
    public class_3499.class_3501 method_15110(class_4538 levelReader, class_2338 jigsawPiecePos, class_2338 jigsawPieceBottomCenterPos, class_3499.class_3501 blockInfoLocal, class_3499.class_3501 blockInfoGlobal, class_3492 structurePlacementData) {
        return blockInfoGlobal;
    }

    protected class_3828<?> method_16772() {
        return StructureProcessorTypeModule.ITEM_FRAME_PROCESSOR;
    }
}

